#!/bin/bash

WORKDIR=$(cd "$(dirname "$0")"; pwd)
PACKAGES="$WORKDIR/packages"

UNIVERSAL="katusha-mfp-driver-universal-amd64"
M130="katusha-mfp-driver-m130-series-amd64"
M247="katusha-mfp-driver-m247-series-amd64"
M348="katusha-mfp-driver-m348-series-amd64"

#--
#-- Initialize_Variables helper function. Depending on the Linux OS, the path
#-- can either be: /usr/bin/command or /bin/command. So, lets set these
#-- dynamically.
#--
set_variable()
{
	VAR_NAME="${1}"
	CMD_NAME="${2}"
	if [ -f "/usr/bin/${CMD_NAME}" ];then
		eval ${VAR_NAME}="/usr/bin/${CMD_NAME}"
	elif [ -f "/bin/${CMD_NAME}" ];then
		eval ${VAR_NAME}="/bin/${CMD_NAME}"
	else
		printf "\n---------------------\nInstallation aborted.\n---------------------\n"
		printf "This script uses a set of system commands which may be\n"
		printf "in a different location on your system.\n\n"
		printf "The following system command was not found: /usr/bin/${CMD_NAME}\n\n"
		exit
	fi
}

#--
#-- Setup System variables which need for Katusha Software installation
#--
initialize_variables()
{
	set_variable ID_CMD id
	set_variable GREP_CMD grep
	set_variable EGREP_CMD egrep
	set_variable LS_CMD ls
	set_variable DIRNAME_CMD dirname
	set_variable BASENAME_CMD basename
	set_variable PRINTF_CMD printf
	set_variable ECHO_CMD echo
	set_variable CAT_CMD cat
	set_variable AWK_CMD awk
	set_variable SED_CMD sed
	set_variable PS_CMD ps
	set_variable CHMOD_CMD chmod
	set_variable TR_CMD tr
	set_variable ICONV_CMD iconv
	set_variable CP_CMD cp
	set_variable RM_CMD rm
}
initialize_variables
echo "Setup System variables which need for Katusha Software installation ==> [DONE]"

#--
#-- Check for root
#--
check_for_root()
{
	ID=`${ID_CMD}`
	${ECHO_CMD} "${ID}" | ${GREP_CMD} "uid=0" >/dev/null 2>&1
   if [ "${?}" != "0" ]; then
		${ECHO_CMD}
		${ECHO_CMD} "You must be a ROOT to run this program."
		${ECHO_CMD}
		exit 1
	fi
}

check_for_root

title="(notice) выберите из списка пакет, который хотите деинсталлировать:"
prompt="(action) выберите требуемое действие:"
options=("$UNIVERSAL"
				"$M130"
				"$M247"
				"$M348"
				)
echo
echo +++++++++++++++++++++++++++++++++
echo Build Date: 23.10.2024\ / Katusha
echo Type: All-in-One
echo Name: Katusha UNIX Uninstaller
echo Version: 2.1-1-stable
echo +++++++++++++++++++++++
echo
echo "Установленные в системе устройства печати Katusha: "
if [[ -f /etc/os-release ]]; then
	if [[ $(cat /etc/os-release | egrep -c "Astra|SparkyLinux|Deepin") -ge 1 ]]; then
		sudo dpkg -l | grep katusha- | awk '{print $2}'
	fi
	if [[ $(cat /etc/os-release | egrep -c "Fedora Linux|ROSA") -ge 1 ]]; then
		sudo rpm -qa | grep "katusha-"
	fi
	if [[ $(cat /etc/os-release | grep -c "altlinux") -ge 1 ]]; then
		rpm -qa | grep "katusha-"
	fi
	if [[ $(cat /etc/os-release | grep -c "RED OS") -ge 1 ]]; then
		dnf list installed | grep "katusha-"
	fi
fi
echo
echo "$title"
PS3="$prompt "
COLUMNS=12
select opt in "${options[@]}" "Отменить"; do
    case "$REPLY" in
		1) echo "Вы выбрали удаление [$opt]";
		bash $WORKDIR/katusha_universal.remove
		break;;
		2) echo "Вы выбрали удаление [$opt]";
		bash $WORKDIR/katusha_m130.remove
		break;;
		3) echo "Вы выбрали удаление [$opt]";
		bash $WORKDIR/katusha_m247.remove
		break;;
		4) echo "Вы выбрали удаление [$opt]";
		bash $WORKDIR/katusha_m348.remove
		break;;
    $((${#options[@]}+1))) echo "Операция была отменена";
		break;;
    *) echo "Неправильный ввод. Вы ошиблись. Повторите.";continue;;
    esac
done
